/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunkmyfrees_store"] = self["webpackChunkmyfrees_store"] || []).push([["chunk-vendors-node_modules_q"],{

/***/ "./node_modules/qrcode/lib/core/reed-solomon-encoder.js":
/*!**************************************************************!*\
  !*** ./node_modules/qrcode/lib/core/reed-solomon-encoder.js ***!
  \**************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

eval("const Polynomial = __webpack_require__(/*! ./polynomial */ \"./node_modules/qrcode/lib/core/polynomial.js\")\n\nfunction ReedSolomonEncoder (degree) {\n  this.genPoly = undefined\n  this.degree = degree\n\n  if (this.degree) this.initialize(this.degree)\n}\n\n/**\n * Initialize the encoder.\n * The input param should correspond to the number of error correction codewords.\n *\n * @param  {Number} degree\n */\nReedSolomonEncoder.prototype.initialize = function initialize (degree) {\n  // create an irreducible generator polynomial\n  this.degree = degree\n  this.genPoly = Polynomial.generateECPolynomial(this.degree)\n}\n\n/**\n * Encodes a chunk of data\n *\n * @param  {Uint8Array} data Buffer containing input data\n * @return {Uint8Array}      Buffer containing encoded data\n */\nReedSolomonEncoder.prototype.encode = function encode (data) {\n  if (!this.genPoly) {\n    throw new Error('Encoder not initialized')\n  }\n\n  // Calculate EC for this data block\n  // extends data size to data+genPoly size\n  const paddedData = new Uint8Array(data.length + this.degree)\n  paddedData.set(data)\n\n  // The error correction codewords are the remainder after dividing the data codewords\n  // by a generator polynomial\n  const remainder = Polynomial.mod(paddedData, this.genPoly)\n\n  // return EC data blocks (last n byte, where n is the degree of genPoly)\n  // If coefficients number in remainder are less than genPoly degree,\n  // pad with 0s to the left to reach the needed number of coefficients\n  const start = this.degree - remainder.length\n  if (start > 0) {\n    const buff = new Uint8Array(this.degree)\n    buff.set(remainder, start)\n\n    return buff\n  }\n\n  return remainder\n}\n\nmodule.exports = ReedSolomonEncoder\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/core/reed-solomon-encoder.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/core/regex.js":
/*!***********************************************!*\
  !*** ./node_modules/qrcode/lib/core/regex.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("const numeric = '[0-9]+'\nconst alphanumeric = '[A-Z $%*+\\\\-./:]+'\nlet kanji = '(?:[u3000-u303F]|[u3040-u309F]|[u30A0-u30FF]|' +\n  '[uFF00-uFFEF]|[u4E00-u9FAF]|[u2605-u2606]|[u2190-u2195]|u203B|' +\n  '[u2010u2015u2018u2019u2025u2026u201Cu201Du2225u2260]|' +\n  '[u0391-u0451]|[u00A7u00A8u00B1u00B4u00D7u00F7])+'\nkanji = kanji.replace(/u/g, '\\\\u')\n\nconst byte = '(?:(?![A-Z0-9 $%*+\\\\-./:]|' + kanji + ')(?:.|[\\r\\n]))+'\n\nexports.KANJI = new RegExp(kanji, 'g')\nexports.BYTE_KANJI = new RegExp('[^A-Z0-9 $%*+\\\\-./:]+', 'g')\nexports.BYTE = new RegExp(byte, 'g')\nexports.NUMERIC = new RegExp(numeric, 'g')\nexports.ALPHANUMERIC = new RegExp(alphanumeric, 'g')\n\nconst TEST_KANJI = new RegExp('^' + kanji + '$')\nconst TEST_NUMERIC = new RegExp('^' + numeric + '$')\nconst TEST_ALPHANUMERIC = new RegExp('^[A-Z0-9 $%*+\\\\-./:]+$')\n\nexports.testKanji = function testKanji (str) {\n  return TEST_KANJI.test(str)\n}\n\nexports.testNumeric = function testNumeric (str) {\n  return TEST_NUMERIC.test(str)\n}\n\nexports.testAlphanumeric = function testAlphanumeric (str) {\n  return TEST_ALPHANUMERIC.test(str)\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/core/regex.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/core/segments.js":
/*!**************************************************!*\
  !*** ./node_modules/qrcode/lib/core/segments.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("const Mode = __webpack_require__(/*! ./mode */ \"./node_modules/qrcode/lib/core/mode.js\")\nconst NumericData = __webpack_require__(/*! ./numeric-data */ \"./node_modules/qrcode/lib/core/numeric-data.js\")\nconst AlphanumericData = __webpack_require__(/*! ./alphanumeric-data */ \"./node_modules/qrcode/lib/core/alphanumeric-data.js\")\nconst ByteData = __webpack_require__(/*! ./byte-data */ \"./node_modules/qrcode/lib/core/byte-data.js\")\nconst KanjiData = __webpack_require__(/*! ./kanji-data */ \"./node_modules/qrcode/lib/core/kanji-data.js\")\nconst Regex = __webpack_require__(/*! ./regex */ \"./node_modules/qrcode/lib/core/regex.js\")\nconst Utils = __webpack_require__(/*! ./utils */ \"./node_modules/qrcode/lib/core/utils.js\")\nconst dijkstra = __webpack_require__(/*! dijkstrajs */ \"./node_modules/dijkstrajs/dijkstra.js\")\n\n/**\n * Returns UTF8 byte length\n *\n * @param  {String} str Input string\n * @return {Number}     Number of byte\n */\nfunction getStringByteLength (str) {\n  return unescape(encodeURIComponent(str)).length\n}\n\n/**\n * Get a list of segments of the specified mode\n * from a string\n *\n * @param  {Mode}   mode Segment mode\n * @param  {String} str  String to process\n * @return {Array}       Array of object with segments data\n */\nfunction getSegments (regex, mode, str) {\n  const segments = []\n  let result\n\n  while ((result = regex.exec(str)) !== null) {\n    segments.push({\n      data: result[0],\n      index: result.index,\n      mode: mode,\n      length: result[0].length\n    })\n  }\n\n  return segments\n}\n\n/**\n * Extracts a series of segments with the appropriate\n * modes from a string\n *\n * @param  {String} dataStr Input string\n * @return {Array}          Array of object with segments data\n */\nfunction getSegmentsFromString (dataStr) {\n  const numSegs = getSegments(Regex.NUMERIC, Mode.NUMERIC, dataStr)\n  const alphaNumSegs = getSegments(Regex.ALPHANUMERIC, Mode.ALPHANUMERIC, dataStr)\n  let byteSegs\n  let kanjiSegs\n\n  if (Utils.isKanjiModeEnabled()) {\n    byteSegs = getSegments(Regex.BYTE, Mode.BYTE, dataStr)\n    kanjiSegs = getSegments(Regex.KANJI, Mode.KANJI, dataStr)\n  } else {\n    byteSegs = getSegments(Regex.BYTE_KANJI, Mode.BYTE, dataStr)\n    kanjiSegs = []\n  }\n\n  const segs = numSegs.concat(alphaNumSegs, byteSegs, kanjiSegs)\n\n  return segs\n    .sort(function (s1, s2) {\n      return s1.index - s2.index\n    })\n    .map(function (obj) {\n      return {\n        data: obj.data,\n        mode: obj.mode,\n        length: obj.length\n      }\n    })\n}\n\n/**\n * Returns how many bits are needed to encode a string of\n * specified length with the specified mode\n *\n * @param  {Number} length String length\n * @param  {Mode} mode     Segment mode\n * @return {Number}        Bit length\n */\nfunction getSegmentBitsLength (length, mode) {\n  switch (mode) {\n    case Mode.NUMERIC:\n      return NumericData.getBitsLength(length)\n    case Mode.ALPHANUMERIC:\n      return AlphanumericData.getBitsLength(length)\n    case Mode.KANJI:\n      return KanjiData.getBitsLength(length)\n    case Mode.BYTE:\n      return ByteData.getBitsLength(length)\n  }\n}\n\n/**\n * Merges adjacent segments which have the same mode\n *\n * @param  {Array} segs Array of object with segments data\n * @return {Array}      Array of object with segments data\n */\nfunction mergeSegments (segs) {\n  return segs.reduce(function (acc, curr) {\n    const prevSeg = acc.length - 1 >= 0 ? acc[acc.length - 1] : null\n    if (prevSeg && prevSeg.mode === curr.mode) {\n      acc[acc.length - 1].data += curr.data\n      return acc\n    }\n\n    acc.push(curr)\n    return acc\n  }, [])\n}\n\n/**\n * Generates a list of all possible nodes combination which\n * will be used to build a segments graph.\n *\n * Nodes are divided by groups. Each group will contain a list of all the modes\n * in which is possible to encode the given text.\n *\n * For example the text '12345' can be encoded as Numeric, Alphanumeric or Byte.\n * The group for '12345' will contain then 3 objects, one for each\n * possible encoding mode.\n *\n * Each node represents a possible segment.\n *\n * @param  {Array} segs Array of object with segments data\n * @return {Array}      Array of object with segments data\n */\nfunction buildNodes (segs) {\n  const nodes = []\n  for (let i = 0; i < segs.length; i++) {\n    const seg = segs[i]\n\n    switch (seg.mode) {\n      case Mode.NUMERIC:\n        nodes.push([seg,\n          { data: seg.data, mode: Mode.ALPHANUMERIC, length: seg.length },\n          { data: seg.data, mode: Mode.BYTE, length: seg.length }\n        ])\n        break\n      case Mode.ALPHANUMERIC:\n        nodes.push([seg,\n          { data: seg.data, mode: Mode.BYTE, length: seg.length }\n        ])\n        break\n      case Mode.KANJI:\n        nodes.push([seg,\n          { data: seg.data, mode: Mode.BYTE, length: getStringByteLength(seg.data) }\n        ])\n        break\n      case Mode.BYTE:\n        nodes.push([\n          { data: seg.data, mode: Mode.BYTE, length: getStringByteLength(seg.data) }\n        ])\n    }\n  }\n\n  return nodes\n}\n\n/**\n * Builds a graph from a list of nodes.\n * All segments in each node group will be connected with all the segments of\n * the next group and so on.\n *\n * At each connection will be assigned a weight depending on the\n * segment's byte length.\n *\n * @param  {Array} nodes    Array of object with segments data\n * @param  {Number} version QR Code version\n * @return {Object}         Graph of all possible segments\n */\nfunction buildGraph (nodes, version) {\n  const table = {}\n  const graph = { start: {} }\n  let prevNodeIds = ['start']\n\n  for (let i = 0; i < nodes.length; i++) {\n    const nodeGroup = nodes[i]\n    const currentNodeIds = []\n\n    for (let j = 0; j < nodeGroup.length; j++) {\n      const node = nodeGroup[j]\n      const key = '' + i + j\n\n      currentNodeIds.push(key)\n      table[key] = { node: node, lastCount: 0 }\n      graph[key] = {}\n\n      for (let n = 0; n < prevNodeIds.length; n++) {\n        const prevNodeId = prevNodeIds[n]\n\n        if (table[prevNodeId] && table[prevNodeId].node.mode === node.mode) {\n          graph[prevNodeId][key] =\n            getSegmentBitsLength(table[prevNodeId].lastCount + node.length, node.mode) -\n            getSegmentBitsLength(table[prevNodeId].lastCount, node.mode)\n\n          table[prevNodeId].lastCount += node.length\n        } else {\n          if (table[prevNodeId]) table[prevNodeId].lastCount = node.length\n\n          graph[prevNodeId][key] = getSegmentBitsLength(node.length, node.mode) +\n            4 + Mode.getCharCountIndicator(node.mode, version) // switch cost\n        }\n      }\n    }\n\n    prevNodeIds = currentNodeIds\n  }\n\n  for (let n = 0; n < prevNodeIds.length; n++) {\n    graph[prevNodeIds[n]].end = 0\n  }\n\n  return { map: graph, table: table }\n}\n\n/**\n * Builds a segment from a specified data and mode.\n * If a mode is not specified, the more suitable will be used.\n *\n * @param  {String} data             Input data\n * @param  {Mode | String} modesHint Data mode\n * @return {Segment}                 Segment\n */\nfunction buildSingleSegment (data, modesHint) {\n  let mode\n  const bestMode = Mode.getBestModeForData(data)\n\n  mode = Mode.from(modesHint, bestMode)\n\n  // Make sure data can be encoded\n  if (mode !== Mode.BYTE && mode.bit < bestMode.bit) {\n    throw new Error('\"' + data + '\"' +\n      ' cannot be encoded with mode ' + Mode.toString(mode) +\n      '.\\n Suggested mode is: ' + Mode.toString(bestMode))\n  }\n\n  // Use Mode.BYTE if Kanji support is disabled\n  if (mode === Mode.KANJI && !Utils.isKanjiModeEnabled()) {\n    mode = Mode.BYTE\n  }\n\n  switch (mode) {\n    case Mode.NUMERIC:\n      return new NumericData(data)\n\n    case Mode.ALPHANUMERIC:\n      return new AlphanumericData(data)\n\n    case Mode.KANJI:\n      return new KanjiData(data)\n\n    case Mode.BYTE:\n      return new ByteData(data)\n  }\n}\n\n/**\n * Builds a list of segments from an array.\n * Array can contain Strings or Objects with segment's info.\n *\n * For each item which is a string, will be generated a segment with the given\n * string and the more appropriate encoding mode.\n *\n * For each item which is an object, will be generated a segment with the given\n * data and mode.\n * Objects must contain at least the property \"data\".\n * If property \"mode\" is not present, the more suitable mode will be used.\n *\n * @param  {Array} array Array of objects with segments data\n * @return {Array}       Array of Segments\n */\nexports.fromArray = function fromArray (array) {\n  return array.reduce(function (acc, seg) {\n    if (typeof seg === 'string') {\n      acc.push(buildSingleSegment(seg, null))\n    } else if (seg.data) {\n      acc.push(buildSingleSegment(seg.data, seg.mode))\n    }\n\n    return acc\n  }, [])\n}\n\n/**\n * Builds an optimized sequence of segments from a string,\n * which will produce the shortest possible bitstream.\n *\n * @param  {String} data    Input string\n * @param  {Number} version QR Code version\n * @return {Array}          Array of segments\n */\nexports.fromString = function fromString (data, version) {\n  const segs = getSegmentsFromString(data, Utils.isKanjiModeEnabled())\n\n  const nodes = buildNodes(segs)\n  const graph = buildGraph(nodes, version)\n  const path = dijkstra.find_path(graph.map, 'start', 'end')\n\n  const optimizedSegs = []\n  for (let i = 1; i < path.length - 1; i++) {\n    optimizedSegs.push(graph.table[path[i]].node)\n  }\n\n  return exports.fromArray(mergeSegments(optimizedSegs))\n}\n\n/**\n * Splits a string in various segments with the modes which\n * best represent their content.\n * The produced segments are far from being optimized.\n * The output of this function is only used to estimate a QR Code version\n * which may contain the data.\n *\n * @param  {string} data Input string\n * @return {Array}       Array of segments\n */\nexports.rawSplit = function rawSplit (data) {\n  return exports.fromArray(\n    getSegmentsFromString(data, Utils.isKanjiModeEnabled())\n  )\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/core/segments.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/core/utils.js":
/*!***********************************************!*\
  !*** ./node_modules/qrcode/lib/core/utils.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("let toSJISFunction\nconst CODEWORDS_COUNT = [\n  0, // Not used\n  26, 44, 70, 100, 134, 172, 196, 242, 292, 346,\n  404, 466, 532, 581, 655, 733, 815, 901, 991, 1085,\n  1156, 1258, 1364, 1474, 1588, 1706, 1828, 1921, 2051, 2185,\n  2323, 2465, 2611, 2761, 2876, 3034, 3196, 3362, 3532, 3706\n]\n\n/**\n * Returns the QR Code size for the specified version\n *\n * @param  {Number} version QR Code version\n * @return {Number}         size of QR code\n */\nexports.getSymbolSize = function getSymbolSize (version) {\n  if (!version) throw new Error('\"version\" cannot be null or undefined')\n  if (version < 1 || version > 40) throw new Error('\"version\" should be in range from 1 to 40')\n  return version * 4 + 17\n}\n\n/**\n * Returns the total number of codewords used to store data and EC information.\n *\n * @param  {Number} version QR Code version\n * @return {Number}         Data length in bits\n */\nexports.getSymbolTotalCodewords = function getSymbolTotalCodewords (version) {\n  return CODEWORDS_COUNT[version]\n}\n\n/**\n * Encode data with Bose-Chaudhuri-Hocquenghem\n *\n * @param  {Number} data Value to encode\n * @return {Number}      Encoded value\n */\nexports.getBCHDigit = function (data) {\n  let digit = 0\n\n  while (data !== 0) {\n    digit++\n    data >>>= 1\n  }\n\n  return digit\n}\n\nexports.setToSJISFunction = function setToSJISFunction (f) {\n  if (typeof f !== 'function') {\n    throw new Error('\"toSJISFunc\" is not a valid function.')\n  }\n\n  toSJISFunction = f\n}\n\nexports.isKanjiModeEnabled = function () {\n  return typeof toSJISFunction !== 'undefined'\n}\n\nexports.toSJIS = function toSJIS (kanji) {\n  return toSJISFunction(kanji)\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/core/utils.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/core/version-check.js":
/*!*******************************************************!*\
  !*** ./node_modules/qrcode/lib/core/version-check.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("/**\n * Check if QR Code version is valid\n *\n * @param  {Number}  version QR Code version\n * @return {Boolean}         true if valid version, false otherwise\n */\nexports.isValid = function isValid (version) {\n  return !isNaN(version) && version >= 1 && version <= 40\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/core/version-check.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/core/version.js":
/*!*************************************************!*\
  !*** ./node_modules/qrcode/lib/core/version.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("const Utils = __webpack_require__(/*! ./utils */ \"./node_modules/qrcode/lib/core/utils.js\")\nconst ECCode = __webpack_require__(/*! ./error-correction-code */ \"./node_modules/qrcode/lib/core/error-correction-code.js\")\nconst ECLevel = __webpack_require__(/*! ./error-correction-level */ \"./node_modules/qrcode/lib/core/error-correction-level.js\")\nconst Mode = __webpack_require__(/*! ./mode */ \"./node_modules/qrcode/lib/core/mode.js\")\nconst VersionCheck = __webpack_require__(/*! ./version-check */ \"./node_modules/qrcode/lib/core/version-check.js\")\n\n// Generator polynomial used to encode version information\nconst G18 = (1 << 12) | (1 << 11) | (1 << 10) | (1 << 9) | (1 << 8) | (1 << 5) | (1 << 2) | (1 << 0)\nconst G18_BCH = Utils.getBCHDigit(G18)\n\nfunction getBestVersionForDataLength (mode, length, errorCorrectionLevel) {\n  for (let currentVersion = 1; currentVersion <= 40; currentVersion++) {\n    if (length <= exports.getCapacity(currentVersion, errorCorrectionLevel, mode)) {\n      return currentVersion\n    }\n  }\n\n  return undefined\n}\n\nfunction getReservedBitsCount (mode, version) {\n  // Character count indicator + mode indicator bits\n  return Mode.getCharCountIndicator(mode, version) + 4\n}\n\nfunction getTotalBitsFromDataArray (segments, version) {\n  let totalBits = 0\n\n  segments.forEach(function (data) {\n    const reservedBits = getReservedBitsCount(data.mode, version)\n    totalBits += reservedBits + data.getBitsLength()\n  })\n\n  return totalBits\n}\n\nfunction getBestVersionForMixedData (segments, errorCorrectionLevel) {\n  for (let currentVersion = 1; currentVersion <= 40; currentVersion++) {\n    const length = getTotalBitsFromDataArray(segments, currentVersion)\n    if (length <= exports.getCapacity(currentVersion, errorCorrectionLevel, Mode.MIXED)) {\n      return currentVersion\n    }\n  }\n\n  return undefined\n}\n\n/**\n * Returns version number from a value.\n * If value is not a valid version, returns defaultValue\n *\n * @param  {Number|String} value        QR Code version\n * @param  {Number}        defaultValue Fallback value\n * @return {Number}                     QR Code version number\n */\nexports.from = function from (value, defaultValue) {\n  if (VersionCheck.isValid(value)) {\n    return parseInt(value, 10)\n  }\n\n  return defaultValue\n}\n\n/**\n * Returns how much data can be stored with the specified QR code version\n * and error correction level\n *\n * @param  {Number} version              QR Code version (1-40)\n * @param  {Number} errorCorrectionLevel Error correction level\n * @param  {Mode}   mode                 Data mode\n * @return {Number}                      Quantity of storable data\n */\nexports.getCapacity = function getCapacity (version, errorCorrectionLevel, mode) {\n  if (!VersionCheck.isValid(version)) {\n    throw new Error('Invalid QR Code version')\n  }\n\n  // Use Byte mode as default\n  if (typeof mode === 'undefined') mode = Mode.BYTE\n\n  // Total codewords for this QR code version (Data + Error correction)\n  const totalCodewords = Utils.getSymbolTotalCodewords(version)\n\n  // Total number of error correction codewords\n  const ecTotalCodewords = ECCode.getTotalCodewordsCount(version, errorCorrectionLevel)\n\n  // Total number of data codewords\n  const dataTotalCodewordsBits = (totalCodewords - ecTotalCodewords) * 8\n\n  if (mode === Mode.MIXED) return dataTotalCodewordsBits\n\n  const usableBits = dataTotalCodewordsBits - getReservedBitsCount(mode, version)\n\n  // Return max number of storable codewords\n  switch (mode) {\n    case Mode.NUMERIC:\n      return Math.floor((usableBits / 10) * 3)\n\n    case Mode.ALPHANUMERIC:\n      return Math.floor((usableBits / 11) * 2)\n\n    case Mode.KANJI:\n      return Math.floor(usableBits / 13)\n\n    case Mode.BYTE:\n    default:\n      return Math.floor(usableBits / 8)\n  }\n}\n\n/**\n * Returns the minimum version needed to contain the amount of data\n *\n * @param  {Segment} data                    Segment of data\n * @param  {Number} [errorCorrectionLevel=H] Error correction level\n * @param  {Mode} mode                       Data mode\n * @return {Number}                          QR Code version\n */\nexports.getBestVersionForData = function getBestVersionForData (data, errorCorrectionLevel) {\n  let seg\n\n  const ecl = ECLevel.from(errorCorrectionLevel, ECLevel.M)\n\n  if (Array.isArray(data)) {\n    if (data.length > 1) {\n      return getBestVersionForMixedData(data, ecl)\n    }\n\n    if (data.length === 0) {\n      return 1\n    }\n\n    seg = data[0]\n  } else {\n    seg = data\n  }\n\n  return getBestVersionForDataLength(seg.mode, seg.getLength(), ecl)\n}\n\n/**\n * Returns version information with relative error correction bits\n *\n * The version information is included in QR Code symbols of version 7 or larger.\n * It consists of an 18-bit sequence containing 6 data bits,\n * with 12 error correction bits calculated using the (18, 6) Golay code.\n *\n * @param  {Number} version QR Code version\n * @return {Number}         Encoded version info bits\n */\nexports.getEncodedBits = function getEncodedBits (version) {\n  if (!VersionCheck.isValid(version) || version < 7) {\n    throw new Error('Invalid QR Code version')\n  }\n\n  let d = version << 12\n\n  while (Utils.getBCHDigit(d) - G18_BCH >= 0) {\n    d ^= (G18 << (Utils.getBCHDigit(d) - G18_BCH))\n  }\n\n  return (version << 12) | d\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/core/version.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/renderer/canvas.js":
/*!****************************************************!*\
  !*** ./node_modules/qrcode/lib/renderer/canvas.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("const Utils = __webpack_require__(/*! ./utils */ \"./node_modules/qrcode/lib/renderer/utils.js\")\n\nfunction clearCanvas (ctx, canvas, size) {\n  ctx.clearRect(0, 0, canvas.width, canvas.height)\n\n  if (!canvas.style) canvas.style = {}\n  canvas.height = size\n  canvas.width = size\n  canvas.style.height = size + 'px'\n  canvas.style.width = size + 'px'\n}\n\nfunction getCanvasElement () {\n  try {\n    return document.createElement('canvas')\n  } catch (e) {\n    throw new Error('You need to specify a canvas element')\n  }\n}\n\nexports.render = function render (qrData, canvas, options) {\n  let opts = options\n  let canvasEl = canvas\n\n  if (typeof opts === 'undefined' && (!canvas || !canvas.getContext)) {\n    opts = canvas\n    canvas = undefined\n  }\n\n  if (!canvas) {\n    canvasEl = getCanvasElement()\n  }\n\n  opts = Utils.getOptions(opts)\n  const size = Utils.getImageWidth(qrData.modules.size, opts)\n\n  const ctx = canvasEl.getContext('2d')\n  const image = ctx.createImageData(size, size)\n  Utils.qrToImageData(image.data, qrData, opts)\n\n  clearCanvas(ctx, canvasEl, size)\n  ctx.putImageData(image, 0, 0)\n\n  return canvasEl\n}\n\nexports.renderToDataURL = function renderToDataURL (qrData, canvas, options) {\n  let opts = options\n\n  if (typeof opts === 'undefined' && (!canvas || !canvas.getContext)) {\n    opts = canvas\n    canvas = undefined\n  }\n\n  if (!opts) opts = {}\n\n  const canvasEl = exports.render(qrData, canvas, opts)\n\n  const type = opts.type || 'image/png'\n  const rendererOpts = opts.rendererOpts || {}\n\n  return canvasEl.toDataURL(type, rendererOpts.quality)\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/renderer/canvas.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/renderer/svg-tag.js":
/*!*****************************************************!*\
  !*** ./node_modules/qrcode/lib/renderer/svg-tag.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("const Utils = __webpack_require__(/*! ./utils */ \"./node_modules/qrcode/lib/renderer/utils.js\")\n\nfunction getColorAttrib (color, attrib) {\n  const alpha = color.a / 255\n  const str = attrib + '=\"' + color.hex + '\"'\n\n  return alpha < 1\n    ? str + ' ' + attrib + '-opacity=\"' + alpha.toFixed(2).slice(1) + '\"'\n    : str\n}\n\nfunction svgCmd (cmd, x, y) {\n  let str = cmd + x\n  if (typeof y !== 'undefined') str += ' ' + y\n\n  return str\n}\n\nfunction qrToPath (data, size, margin) {\n  let path = ''\n  let moveBy = 0\n  let newRow = false\n  let lineLength = 0\n\n  for (let i = 0; i < data.length; i++) {\n    const col = Math.floor(i % size)\n    const row = Math.floor(i / size)\n\n    if (!col && !newRow) newRow = true\n\n    if (data[i]) {\n      lineLength++\n\n      if (!(i > 0 && col > 0 && data[i - 1])) {\n        path += newRow\n          ? svgCmd('M', col + margin, 0.5 + row + margin)\n          : svgCmd('m', moveBy, 0)\n\n        moveBy = 0\n        newRow = false\n      }\n\n      if (!(col + 1 < size && data[i + 1])) {\n        path += svgCmd('h', lineLength)\n        lineLength = 0\n      }\n    } else {\n      moveBy++\n    }\n  }\n\n  return path\n}\n\nexports.render = function render (qrData, options, cb) {\n  const opts = Utils.getOptions(options)\n  const size = qrData.modules.size\n  const data = qrData.modules.data\n  const qrcodesize = size + opts.margin * 2\n\n  const bg = !opts.color.light.a\n    ? ''\n    : '<path ' + getColorAttrib(opts.color.light, 'fill') +\n      ' d=\"M0 0h' + qrcodesize + 'v' + qrcodesize + 'H0z\"/>'\n\n  const path =\n    '<path ' + getColorAttrib(opts.color.dark, 'stroke') +\n    ' d=\"' + qrToPath(data, size, opts.margin) + '\"/>'\n\n  const viewBox = 'viewBox=\"' + '0 0 ' + qrcodesize + ' ' + qrcodesize + '\"'\n\n  const width = !opts.width ? '' : 'width=\"' + opts.width + '\" height=\"' + opts.width + '\" '\n\n  const svgTag = '<svg xmlns=\"http://www.w3.org/2000/svg\" ' + width + viewBox + ' shape-rendering=\"crispEdges\">' + bg + path + '</svg>\\n'\n\n  if (typeof cb === 'function') {\n    cb(null, svgTag)\n  }\n\n  return svgTag\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/renderer/svg-tag.js?");

/***/ }),

/***/ "./node_modules/qrcode/lib/renderer/utils.js":
/*!***************************************************!*\
  !*** ./node_modules/qrcode/lib/renderer/utils.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("function hex2rgba (hex) {\n  if (typeof hex === 'number') {\n    hex = hex.toString()\n  }\n\n  if (typeof hex !== 'string') {\n    throw new Error('Color should be defined as hex string')\n  }\n\n  let hexCode = hex.slice().replace('#', '').split('')\n  if (hexCode.length < 3 || hexCode.length === 5 || hexCode.length > 8) {\n    throw new Error('Invalid hex color: ' + hex)\n  }\n\n  // Convert from short to long form (fff -> ffffff)\n  if (hexCode.length === 3 || hexCode.length === 4) {\n    hexCode = Array.prototype.concat.apply([], hexCode.map(function (c) {\n      return [c, c]\n    }))\n  }\n\n  // Add default alpha value\n  if (hexCode.length === 6) hexCode.push('F', 'F')\n\n  const hexValue = parseInt(hexCode.join(''), 16)\n\n  return {\n    r: (hexValue >> 24) & 255,\n    g: (hexValue >> 16) & 255,\n    b: (hexValue >> 8) & 255,\n    a: hexValue & 255,\n    hex: '#' + hexCode.slice(0, 6).join('')\n  }\n}\n\nexports.getOptions = function getOptions (options) {\n  if (!options) options = {}\n  if (!options.color) options.color = {}\n\n  const margin = typeof options.margin === 'undefined' ||\n    options.margin === null ||\n    options.margin < 0\n    ? 4\n    : options.margin\n\n  const width = options.width && options.width >= 21 ? options.width : undefined\n  const scale = options.scale || 4\n\n  return {\n    width: width,\n    scale: width ? 4 : scale,\n    margin: margin,\n    color: {\n      dark: hex2rgba(options.color.dark || '#000000ff'),\n      light: hex2rgba(options.color.light || '#ffffffff')\n    },\n    type: options.type,\n    rendererOpts: options.rendererOpts || {}\n  }\n}\n\nexports.getScale = function getScale (qrSize, opts) {\n  return opts.width && opts.width >= qrSize + opts.margin * 2\n    ? opts.width / (qrSize + opts.margin * 2)\n    : opts.scale\n}\n\nexports.getImageWidth = function getImageWidth (qrSize, opts) {\n  const scale = exports.getScale(qrSize, opts)\n  return Math.floor((qrSize + opts.margin * 2) * scale)\n}\n\nexports.qrToImageData = function qrToImageData (imgData, qr, opts) {\n  const size = qr.modules.size\n  const data = qr.modules.data\n  const scale = exports.getScale(size, opts)\n  const symbolSize = Math.floor((size + opts.margin * 2) * scale)\n  const scaledMargin = opts.margin * scale\n  const palette = [opts.color.light, opts.color.dark]\n\n  for (let i = 0; i < symbolSize; i++) {\n    for (let j = 0; j < symbolSize; j++) {\n      let posDst = (i * symbolSize + j) * 4\n      let pxColor = opts.color.light\n\n      if (i >= scaledMargin && j >= scaledMargin &&\n        i < symbolSize - scaledMargin && j < symbolSize - scaledMargin) {\n        const iSrc = Math.floor((i - scaledMargin) / scale)\n        const jSrc = Math.floor((j - scaledMargin) / scale)\n        pxColor = palette[data[iSrc * size + jSrc] ? 1 : 0]\n      }\n\n      imgData[posDst++] = pxColor.r\n      imgData[posDst++] = pxColor.g\n      imgData[posDst++] = pxColor.b\n      imgData[posDst] = pxColor.a\n    }\n  }\n}\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/qrcode/lib/renderer/utils.js?");

/***/ }),

/***/ "./node_modules/signature_pad/dist/signature_pad.js":
/*!**********************************************************!*\
  !*** ./node_modules/signature_pad/dist/signature_pad.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/*!\n * Signature Pad v3.0.0-beta.4 | https://github.com/szimek/signature_pad\n * (c) 2020 Szymon Nowak | Released under the MIT license\n */\n\nclass Point {\n    constructor(x, y, time) {\n        this.x = x;\n        this.y = y;\n        this.time = time || Date.now();\n    }\n    distanceTo(start) {\n        return Math.sqrt(Math.pow(this.x - start.x, 2) + Math.pow(this.y - start.y, 2));\n    }\n    equals(other) {\n        return this.x === other.x && this.y === other.y && this.time === other.time;\n    }\n    velocityFrom(start) {\n        return this.time !== start.time\n            ? this.distanceTo(start) / (this.time - start.time)\n            : 0;\n    }\n}\n\nclass Bezier {\n    constructor(startPoint, control2, control1, endPoint, startWidth, endWidth) {\n        this.startPoint = startPoint;\n        this.control2 = control2;\n        this.control1 = control1;\n        this.endPoint = endPoint;\n        this.startWidth = startWidth;\n        this.endWidth = endWidth;\n    }\n    static fromPoints(points, widths) {\n        const c2 = this.calculateControlPoints(points[0], points[1], points[2]).c2;\n        const c3 = this.calculateControlPoints(points[1], points[2], points[3]).c1;\n        return new Bezier(points[1], c2, c3, points[2], widths.start, widths.end);\n    }\n    static calculateControlPoints(s1, s2, s3) {\n        const dx1 = s1.x - s2.x;\n        const dy1 = s1.y - s2.y;\n        const dx2 = s2.x - s3.x;\n        const dy2 = s2.y - s3.y;\n        const m1 = { x: (s1.x + s2.x) / 2.0, y: (s1.y + s2.y) / 2.0 };\n        const m2 = { x: (s2.x + s3.x) / 2.0, y: (s2.y + s3.y) / 2.0 };\n        const l1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);\n        const l2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);\n        const dxm = m1.x - m2.x;\n        const dym = m1.y - m2.y;\n        const k = l2 / (l1 + l2);\n        const cm = { x: m2.x + dxm * k, y: m2.y + dym * k };\n        const tx = s2.x - cm.x;\n        const ty = s2.y - cm.y;\n        return {\n            c1: new Point(m1.x + tx, m1.y + ty),\n            c2: new Point(m2.x + tx, m2.y + ty),\n        };\n    }\n    length() {\n        const steps = 10;\n        let length = 0;\n        let px;\n        let py;\n        for (let i = 0; i <= steps; i += 1) {\n            const t = i / steps;\n            const cx = this.point(t, this.startPoint.x, this.control1.x, this.control2.x, this.endPoint.x);\n            const cy = this.point(t, this.startPoint.y, this.control1.y, this.control2.y, this.endPoint.y);\n            if (i > 0) {\n                const xdiff = cx - px;\n                const ydiff = cy - py;\n                length += Math.sqrt(xdiff * xdiff + ydiff * ydiff);\n            }\n            px = cx;\n            py = cy;\n        }\n        return length;\n    }\n    point(t, start, c1, c2, end) {\n        return (start * (1.0 - t) * (1.0 - t) * (1.0 - t))\n            + (3.0 * c1 * (1.0 - t) * (1.0 - t) * t)\n            + (3.0 * c2 * (1.0 - t) * t * t)\n            + (end * t * t * t);\n    }\n}\n\nfunction throttle(fn, wait = 250) {\n    let previous = 0;\n    let timeout = null;\n    let result;\n    let storedContext;\n    let storedArgs;\n    const later = () => {\n        previous = Date.now();\n        timeout = null;\n        result = fn.apply(storedContext, storedArgs);\n        if (!timeout) {\n            storedContext = null;\n            storedArgs = [];\n        }\n    };\n    return function wrapper(...args) {\n        const now = Date.now();\n        const remaining = wait - (now - previous);\n        storedContext = this;\n        storedArgs = args;\n        if (remaining <= 0 || remaining > wait) {\n            if (timeout) {\n                clearTimeout(timeout);\n                timeout = null;\n            }\n            previous = now;\n            result = fn.apply(storedContext, storedArgs);\n            if (!timeout) {\n                storedContext = null;\n                storedArgs = [];\n            }\n        }\n        else if (!timeout) {\n            timeout = window.setTimeout(later, remaining);\n        }\n        return result;\n    };\n}\n\nclass SignaturePad {\n    constructor(canvas, options = {}) {\n        this.canvas = canvas;\n        this.options = options;\n        this._handleMouseDown = (event) => {\n            if (event.which === 1) {\n                this._mouseButtonDown = true;\n                this._strokeBegin(event);\n            }\n        };\n        this._handleMouseMove = (event) => {\n            if (this._mouseButtonDown) {\n                this._strokeMoveUpdate(event);\n            }\n        };\n        this._handleMouseUp = (event) => {\n            if (event.which === 1 && this._mouseButtonDown) {\n                this._mouseButtonDown = false;\n                this._strokeEnd(event);\n            }\n        };\n        this._handleTouchStart = (event) => {\n            event.preventDefault();\n            if (event.targetTouches.length === 1) {\n                const touch = event.changedTouches[0];\n                this._strokeBegin(touch);\n            }\n        };\n        this._handleTouchMove = (event) => {\n            event.preventDefault();\n            const touch = event.targetTouches[0];\n            this._strokeMoveUpdate(touch);\n        };\n        this._handleTouchEnd = (event) => {\n            const wasCanvasTouched = event.target === this.canvas;\n            if (wasCanvasTouched) {\n                event.preventDefault();\n                const touch = event.changedTouches[0];\n                this._strokeEnd(touch);\n            }\n        };\n        this.velocityFilterWeight = options.velocityFilterWeight || 0.7;\n        this.minWidth = options.minWidth || 0.5;\n        this.maxWidth = options.maxWidth || 2.5;\n        this.throttle = ('throttle' in options ? options.throttle : 16);\n        this.minDistance = ('minDistance' in options\n            ? options.minDistance\n            : 5);\n        this.dotSize =\n            options.dotSize ||\n                function dotSize() {\n                    return (this.minWidth + this.maxWidth) / 2;\n                };\n        this.penColor = options.penColor || 'black';\n        this.backgroundColor = options.backgroundColor || 'rgba(0,0,0,0)';\n        this.onBegin = options.onBegin;\n        this.onEnd = options.onEnd;\n        this._strokeMoveUpdate = this.throttle\n            ? throttle(SignaturePad.prototype._strokeUpdate, this.throttle)\n            : SignaturePad.prototype._strokeUpdate;\n        this._ctx = canvas.getContext('2d');\n        this.clear();\n        this.on();\n    }\n    clear() {\n        const { _ctx: ctx, canvas } = this;\n        ctx.fillStyle = this.backgroundColor;\n        ctx.clearRect(0, 0, canvas.width, canvas.height);\n        ctx.fillRect(0, 0, canvas.width, canvas.height);\n        this._data = [];\n        this._reset();\n        this._isEmpty = true;\n    }\n    fromDataURL(dataUrl, options = {}, callback) {\n        const image = new Image();\n        const ratio = options.ratio || window.devicePixelRatio || 1;\n        const width = options.width || this.canvas.width / ratio;\n        const height = options.height || this.canvas.height / ratio;\n        this._reset();\n        image.onload = () => {\n            this._ctx.drawImage(image, 0, 0, width, height);\n            if (callback) {\n                callback();\n            }\n        };\n        image.onerror = (error) => {\n            if (callback) {\n                callback(error);\n            }\n        };\n        image.src = dataUrl;\n        this._isEmpty = false;\n    }\n    toDataURL(type = 'image/png', encoderOptions) {\n        switch (type) {\n            case 'image/svg+xml':\n                return this._toSVG();\n            default:\n                return this.canvas.toDataURL(type, encoderOptions);\n        }\n    }\n    on() {\n        this.canvas.style.touchAction = 'none';\n        this.canvas.style.msTouchAction = 'none';\n        if (window.PointerEvent) {\n            this._handlePointerEvents();\n        }\n        else {\n            this._handleMouseEvents();\n            if ('ontouchstart' in window) {\n                this._handleTouchEvents();\n            }\n        }\n    }\n    off() {\n        this.canvas.style.touchAction = 'auto';\n        this.canvas.style.msTouchAction = 'auto';\n        this.canvas.removeEventListener('pointerdown', this._handleMouseDown);\n        this.canvas.removeEventListener('pointermove', this._handleMouseMove);\n        document.removeEventListener('pointerup', this._handleMouseUp);\n        this.canvas.removeEventListener('mousedown', this._handleMouseDown);\n        this.canvas.removeEventListener('mousemove', this._handleMouseMove);\n        document.removeEventListener('mouseup', this._handleMouseUp);\n        this.canvas.removeEventListener('touchstart', this._handleTouchStart);\n        this.canvas.removeEventListener('touchmove', this._handleTouchMove);\n        this.canvas.removeEventListener('touchend', this._handleTouchEnd);\n    }\n    isEmpty() {\n        return this._isEmpty;\n    }\n    fromData(pointGroups) {\n        this.clear();\n        this._fromData(pointGroups, ({ color, curve }) => this._drawCurve({ color, curve }), ({ color, point }) => this._drawDot({ color, point }));\n        this._data = pointGroups;\n    }\n    toData() {\n        return this._data;\n    }\n    _strokeBegin(event) {\n        const newPointGroup = {\n            color: this.penColor,\n            points: [],\n        };\n        if (typeof this.onBegin === 'function') {\n            this.onBegin(event);\n        }\n        this._data.push(newPointGroup);\n        this._reset();\n        this._strokeUpdate(event);\n    }\n    _strokeUpdate(event) {\n        if (this._data.length === 0) {\n            this._strokeBegin(event);\n            return;\n        }\n        const x = event.clientX;\n        const y = event.clientY;\n        const point = this._createPoint(x, y);\n        const lastPointGroup = this._data[this._data.length - 1];\n        const lastPoints = lastPointGroup.points;\n        const lastPoint = lastPoints.length > 0 && lastPoints[lastPoints.length - 1];\n        const isLastPointTooClose = lastPoint\n            ? point.distanceTo(lastPoint) <= this.minDistance\n            : false;\n        const color = lastPointGroup.color;\n        if (!lastPoint || !(lastPoint && isLastPointTooClose)) {\n            const curve = this._addPoint(point);\n            if (!lastPoint) {\n                this._drawDot({ color, point });\n            }\n            else if (curve) {\n                this._drawCurve({ color, curve });\n            }\n            lastPoints.push({\n                time: point.time,\n                x: point.x,\n                y: point.y,\n            });\n        }\n    }\n    _strokeEnd(event) {\n        this._strokeUpdate(event);\n        if (typeof this.onEnd === 'function') {\n            this.onEnd(event);\n        }\n    }\n    _handlePointerEvents() {\n        this._mouseButtonDown = false;\n        this.canvas.addEventListener('pointerdown', this._handleMouseDown);\n        this.canvas.addEventListener('pointermove', this._handleMouseMove);\n        document.addEventListener('pointerup', this._handleMouseUp);\n    }\n    _handleMouseEvents() {\n        this._mouseButtonDown = false;\n        this.canvas.addEventListener('mousedown', this._handleMouseDown);\n        this.canvas.addEventListener('mousemove', this._handleMouseMove);\n        document.addEventListener('mouseup', this._handleMouseUp);\n    }\n    _handleTouchEvents() {\n        this.canvas.addEventListener('touchstart', this._handleTouchStart);\n        this.canvas.addEventListener('touchmove', this._handleTouchMove);\n        this.canvas.addEventListener('touchend', this._handleTouchEnd);\n    }\n    _reset() {\n        this._lastPoints = [];\n        this._lastVelocity = 0;\n        this._lastWidth = (this.minWidth + this.maxWidth) / 2;\n        this._ctx.fillStyle = this.penColor;\n    }\n    _createPoint(x, y) {\n        const rect = this.canvas.getBoundingClientRect();\n        return new Point(x - rect.left, y - rect.top, new Date().getTime());\n    }\n    _addPoint(point) {\n        const { _lastPoints } = this;\n        _lastPoints.push(point);\n        if (_lastPoints.length > 2) {\n            if (_lastPoints.length === 3) {\n                _lastPoints.unshift(_lastPoints[0]);\n            }\n            const widths = this._calculateCurveWidths(_lastPoints[1], _lastPoints[2]);\n            const curve = Bezier.fromPoints(_lastPoints, widths);\n            _lastPoints.shift();\n            return curve;\n        }\n        return null;\n    }\n    _calculateCurveWidths(startPoint, endPoint) {\n        const velocity = this.velocityFilterWeight * endPoint.velocityFrom(startPoint) +\n            (1 - this.velocityFilterWeight) * this._lastVelocity;\n        const newWidth = this._strokeWidth(velocity);\n        const widths = {\n            end: newWidth,\n            start: this._lastWidth,\n        };\n        this._lastVelocity = velocity;\n        this._lastWidth = newWidth;\n        return widths;\n    }\n    _strokeWidth(velocity) {\n        return Math.max(this.maxWidth / (velocity + 1), this.minWidth);\n    }\n    _drawCurveSegment(x, y, width) {\n        const ctx = this._ctx;\n        ctx.moveTo(x, y);\n        ctx.arc(x, y, width, 0, 2 * Math.PI, false);\n        this._isEmpty = false;\n    }\n    _drawCurve({ color, curve }) {\n        const ctx = this._ctx;\n        const widthDelta = curve.endWidth - curve.startWidth;\n        const drawSteps = Math.floor(curve.length()) * 2;\n        ctx.beginPath();\n        ctx.fillStyle = color;\n        for (let i = 0; i < drawSteps; i += 1) {\n            const t = i / drawSteps;\n            const tt = t * t;\n            const ttt = tt * t;\n            const u = 1 - t;\n            const uu = u * u;\n            const uuu = uu * u;\n            let x = uuu * curve.startPoint.x;\n            x += 3 * uu * t * curve.control1.x;\n            x += 3 * u * tt * curve.control2.x;\n            x += ttt * curve.endPoint.x;\n            let y = uuu * curve.startPoint.y;\n            y += 3 * uu * t * curve.control1.y;\n            y += 3 * u * tt * curve.control2.y;\n            y += ttt * curve.endPoint.y;\n            const width = Math.min(curve.startWidth + ttt * widthDelta, this.maxWidth);\n            this._drawCurveSegment(x, y, width);\n        }\n        ctx.closePath();\n        ctx.fill();\n    }\n    _drawDot({ color, point, }) {\n        const ctx = this._ctx;\n        const width = typeof this.dotSize === 'function' ? this.dotSize() : this.dotSize;\n        ctx.beginPath();\n        this._drawCurveSegment(point.x, point.y, width);\n        ctx.closePath();\n        ctx.fillStyle = color;\n        ctx.fill();\n    }\n    _fromData(pointGroups, drawCurve, drawDot) {\n        for (const group of pointGroups) {\n            const { color, points } = group;\n            if (points.length > 1) {\n                for (let j = 0; j < points.length; j += 1) {\n                    const basicPoint = points[j];\n                    const point = new Point(basicPoint.x, basicPoint.y, basicPoint.time);\n                    this.penColor = color;\n                    if (j === 0) {\n                        this._reset();\n                    }\n                    const curve = this._addPoint(point);\n                    if (curve) {\n                        drawCurve({ color, curve });\n                    }\n                }\n            }\n            else {\n                this._reset();\n                drawDot({\n                    color,\n                    point: points[0],\n                });\n            }\n        }\n    }\n    _toSVG() {\n        const pointGroups = this._data;\n        const ratio = Math.max(window.devicePixelRatio || 1, 1);\n        const minX = 0;\n        const minY = 0;\n        const maxX = this.canvas.width / ratio;\n        const maxY = this.canvas.height / ratio;\n        const svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');\n        svg.setAttribute('width', this.canvas.width.toString());\n        svg.setAttribute('height', this.canvas.height.toString());\n        this._fromData(pointGroups, ({ color, curve }) => {\n            const path = document.createElement('path');\n            if (!isNaN(curve.control1.x) &&\n                !isNaN(curve.control1.y) &&\n                !isNaN(curve.control2.x) &&\n                !isNaN(curve.control2.y)) {\n                const attr = `M ${curve.startPoint.x.toFixed(3)},${curve.startPoint.y.toFixed(3)} ` +\n                    `C ${curve.control1.x.toFixed(3)},${curve.control1.y.toFixed(3)} ` +\n                    `${curve.control2.x.toFixed(3)},${curve.control2.y.toFixed(3)} ` +\n                    `${curve.endPoint.x.toFixed(3)},${curve.endPoint.y.toFixed(3)}`;\n                path.setAttribute('d', attr);\n                path.setAttribute('stroke-width', (curve.endWidth * 2.25).toFixed(3));\n                path.setAttribute('stroke', color);\n                path.setAttribute('fill', 'none');\n                path.setAttribute('stroke-linecap', 'round');\n                svg.appendChild(path);\n            }\n        }, ({ color, point }) => {\n            const circle = document.createElement('circle');\n            const dotSize = typeof this.dotSize === 'function' ? this.dotSize() : this.dotSize;\n            circle.setAttribute('r', dotSize.toString());\n            circle.setAttribute('cx', point.x.toString());\n            circle.setAttribute('cy', point.y.toString());\n            circle.setAttribute('fill', color);\n            svg.appendChild(circle);\n        });\n        const prefix = 'data:image/svg+xml;base64,';\n        const header = '<svg' +\n            ' xmlns=\"http://www.w3.org/2000/svg\"' +\n            ' xmlns:xlink=\"http://www.w3.org/1999/xlink\"' +\n            ` viewBox=\"${minX} ${minY} ${maxX} ${maxY}\"` +\n            ` width=\"${maxX}\"` +\n            ` height=\"${maxY}\"` +\n            '>';\n        let body = svg.innerHTML;\n        if (body === undefined) {\n            const dummy = document.createElement('dummy');\n            const nodes = svg.childNodes;\n            dummy.innerHTML = '';\n            for (let i = 0; i < nodes.length; i += 1) {\n                dummy.appendChild(nodes[i].cloneNode(true));\n            }\n            body = dummy.innerHTML;\n        }\n        const footer = '</svg>';\n        const data = header + body + footer;\n        return prefix + btoa(data);\n    }\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (SignaturePad);\n//# sourceMappingURL=signature_pad.js.map\n\n\n//# sourceURL=webpack://myfrees_store/./node_modules/signature_pad/dist/signature_pad.js?");

/***/ })

}]);