"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunkmyfrees_store"] = self["webpackChunkmyfrees_store"] || []).push([["vendors-node_modules_jsbarcode_bin_barcodes_EAN_UPC_index_js-node_modules_jsbarcode_bin_barco-532b8b"],{

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN.js":
/*!************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _constants = __webpack_require__(/*! ./constants */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js\");\n\nvar _encoder = __webpack_require__(/*! ./encoder */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js\");\n\nvar _encoder2 = _interopRequireDefault(_encoder);\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\n// Base class for EAN8 & EAN13\nvar EAN = function (_Barcode) {\n\t_inherits(EAN, _Barcode);\n\n\tfunction EAN(data, options) {\n\t\t_classCallCheck(this, EAN);\n\n\t\t// Make sure the font is not bigger than the space between the guard bars\n\t\tvar _this = _possibleConstructorReturn(this, (EAN.__proto__ || Object.getPrototypeOf(EAN)).call(this, data, options));\n\n\t\t_this.fontSize = !options.flat && options.fontSize > options.width * 10 ? options.width * 10 : options.fontSize;\n\n\t\t// Make the guard bars go down half the way of the text\n\t\t_this.guardHeight = options.height + _this.fontSize / 2 + options.textMargin;\n\t\treturn _this;\n\t}\n\n\t_createClass(EAN, [{\n\t\tkey: 'encode',\n\t\tvalue: function encode() {\n\t\t\treturn this.options.flat ? this.encodeFlat() : this.encodeGuarded();\n\t\t}\n\t}, {\n\t\tkey: 'leftText',\n\t\tvalue: function leftText(from, to) {\n\t\t\treturn this.text.substr(from, to);\n\t\t}\n\t}, {\n\t\tkey: 'leftEncode',\n\t\tvalue: function leftEncode(data, structure) {\n\t\t\treturn (0, _encoder2.default)(data, structure);\n\t\t}\n\t}, {\n\t\tkey: 'rightText',\n\t\tvalue: function rightText(from, to) {\n\t\t\treturn this.text.substr(from, to);\n\t\t}\n\t}, {\n\t\tkey: 'rightEncode',\n\t\tvalue: function rightEncode(data, structure) {\n\t\t\treturn (0, _encoder2.default)(data, structure);\n\t\t}\n\t}, {\n\t\tkey: 'encodeGuarded',\n\t\tvalue: function encodeGuarded() {\n\t\t\tvar textOptions = { fontSize: this.fontSize };\n\t\t\tvar guardOptions = { height: this.guardHeight };\n\n\t\t\treturn [{ data: _constants.SIDE_BIN, options: guardOptions }, { data: this.leftEncode(), text: this.leftText(), options: textOptions }, { data: _constants.MIDDLE_BIN, options: guardOptions }, { data: this.rightEncode(), text: this.rightText(), options: textOptions }, { data: _constants.SIDE_BIN, options: guardOptions }];\n\t\t}\n\t}, {\n\t\tkey: 'encodeFlat',\n\t\tvalue: function encodeFlat() {\n\t\t\tvar data = [_constants.SIDE_BIN, this.leftEncode(), _constants.MIDDLE_BIN, this.rightEncode(), _constants.SIDE_BIN];\n\n\t\t\treturn {\n\t\t\t\tdata: data.join(''),\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\t}]);\n\n\treturn EAN;\n}(_Barcode3.default);\n\nexports[\"default\"] = EAN;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN13.js":
/*!**************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN13.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if (\"value\" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };\n\nvar _constants = __webpack_require__(/*! ./constants */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js\");\n\nvar _EAN2 = __webpack_require__(/*! ./EAN */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN.js\");\n\nvar _EAN3 = _interopRequireDefault(_EAN2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Encoding documentation:\n// https://en.wikipedia.org/wiki/International_Article_Number_(EAN)#Binary_encoding_of_data_digits_into_EAN-13_barcode\n\n// Calculate the checksum digit\n// https://en.wikipedia.org/wiki/International_Article_Number_(EAN)#Calculation_of_checksum_digit\nvar checksum = function checksum(number) {\n\tvar res = number.substr(0, 12).split('').map(function (n) {\n\t\treturn +n;\n\t}).reduce(function (sum, a, idx) {\n\t\treturn idx % 2 ? sum + a * 3 : sum + a;\n\t}, 0);\n\n\treturn (10 - res % 10) % 10;\n};\n\nvar EAN13 = function (_EAN) {\n\t_inherits(EAN13, _EAN);\n\n\tfunction EAN13(data, options) {\n\t\t_classCallCheck(this, EAN13);\n\n\t\t// Add checksum if it does not exist\n\t\tif (data.search(/^[0-9]{12}$/) !== -1) {\n\t\t\tdata += checksum(data);\n\t\t}\n\n\t\t// Adds a last character to the end of the barcode\n\t\tvar _this = _possibleConstructorReturn(this, (EAN13.__proto__ || Object.getPrototypeOf(EAN13)).call(this, data, options));\n\n\t\t_this.lastChar = options.lastChar;\n\t\treturn _this;\n\t}\n\n\t_createClass(EAN13, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^[0-9]{13}$/) !== -1 && +this.data[12] === checksum(this.data);\n\t\t}\n\t}, {\n\t\tkey: 'leftText',\n\t\tvalue: function leftText() {\n\t\t\treturn _get(EAN13.prototype.__proto__ || Object.getPrototypeOf(EAN13.prototype), 'leftText', this).call(this, 1, 6);\n\t\t}\n\t}, {\n\t\tkey: 'leftEncode',\n\t\tvalue: function leftEncode() {\n\t\t\tvar data = this.data.substr(1, 6);\n\t\t\tvar structure = _constants.EAN13_STRUCTURE[this.data[0]];\n\t\t\treturn _get(EAN13.prototype.__proto__ || Object.getPrototypeOf(EAN13.prototype), 'leftEncode', this).call(this, data, structure);\n\t\t}\n\t}, {\n\t\tkey: 'rightText',\n\t\tvalue: function rightText() {\n\t\t\treturn _get(EAN13.prototype.__proto__ || Object.getPrototypeOf(EAN13.prototype), 'rightText', this).call(this, 7, 6);\n\t\t}\n\t}, {\n\t\tkey: 'rightEncode',\n\t\tvalue: function rightEncode() {\n\t\t\tvar data = this.data.substr(7, 6);\n\t\t\treturn _get(EAN13.prototype.__proto__ || Object.getPrototypeOf(EAN13.prototype), 'rightEncode', this).call(this, data, 'RRRRRR');\n\t\t}\n\n\t\t// The \"standard\" way of printing EAN13 barcodes with guard bars\n\n\t}, {\n\t\tkey: 'encodeGuarded',\n\t\tvalue: function encodeGuarded() {\n\t\t\tvar data = _get(EAN13.prototype.__proto__ || Object.getPrototypeOf(EAN13.prototype), 'encodeGuarded', this).call(this);\n\n\t\t\t// Extend data with left digit & last character\n\t\t\tif (this.options.displayValue) {\n\t\t\t\tdata.unshift({\n\t\t\t\t\tdata: '000000000000',\n\t\t\t\t\ttext: this.text.substr(0, 1),\n\t\t\t\t\toptions: { textAlign: 'left', fontSize: this.fontSize }\n\t\t\t\t});\n\n\t\t\t\tif (this.options.lastChar) {\n\t\t\t\t\tdata.push({\n\t\t\t\t\t\tdata: '00'\n\t\t\t\t\t});\n\t\t\t\t\tdata.push({\n\t\t\t\t\t\tdata: '00000',\n\t\t\t\t\t\ttext: this.options.lastChar,\n\t\t\t\t\t\toptions: { fontSize: this.fontSize }\n\t\t\t\t\t});\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn data;\n\t\t}\n\t}]);\n\n\treturn EAN13;\n}(_EAN3.default);\n\nexports[\"default\"] = EAN13;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN13.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN2.js":
/*!*************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN2.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _constants = __webpack_require__(/*! ./constants */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js\");\n\nvar _encoder = __webpack_require__(/*! ./encoder */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js\");\n\nvar _encoder2 = _interopRequireDefault(_encoder);\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Encoding documentation:\n// https://en.wikipedia.org/wiki/EAN_2#Encoding\n\nvar EAN2 = function (_Barcode) {\n\t_inherits(EAN2, _Barcode);\n\n\tfunction EAN2(data, options) {\n\t\t_classCallCheck(this, EAN2);\n\n\t\treturn _possibleConstructorReturn(this, (EAN2.__proto__ || Object.getPrototypeOf(EAN2)).call(this, data, options));\n\t}\n\n\t_createClass(EAN2, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^[0-9]{2}$/) !== -1;\n\t\t}\n\t}, {\n\t\tkey: 'encode',\n\t\tvalue: function encode() {\n\t\t\t// Choose the structure based on the number mod 4\n\t\t\tvar structure = _constants.EAN2_STRUCTURE[parseInt(this.data) % 4];\n\t\t\treturn {\n\t\t\t\t// Start bits + Encode the two digits with 01 in between\n\t\t\t\tdata: '1011' + (0, _encoder2.default)(this.data, structure, '01'),\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\t}]);\n\n\treturn EAN2;\n}(_Barcode3.default);\n\nexports[\"default\"] = EAN2;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN2.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN5.js":
/*!*************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN5.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _constants = __webpack_require__(/*! ./constants */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js\");\n\nvar _encoder = __webpack_require__(/*! ./encoder */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js\");\n\nvar _encoder2 = _interopRequireDefault(_encoder);\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Encoding documentation:\n// https://en.wikipedia.org/wiki/EAN_5#Encoding\n\nvar checksum = function checksum(data) {\n\tvar result = data.split('').map(function (n) {\n\t\treturn +n;\n\t}).reduce(function (sum, a, idx) {\n\t\treturn idx % 2 ? sum + a * 9 : sum + a * 3;\n\t}, 0);\n\treturn result % 10;\n};\n\nvar EAN5 = function (_Barcode) {\n\t_inherits(EAN5, _Barcode);\n\n\tfunction EAN5(data, options) {\n\t\t_classCallCheck(this, EAN5);\n\n\t\treturn _possibleConstructorReturn(this, (EAN5.__proto__ || Object.getPrototypeOf(EAN5)).call(this, data, options));\n\t}\n\n\t_createClass(EAN5, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^[0-9]{5}$/) !== -1;\n\t\t}\n\t}, {\n\t\tkey: 'encode',\n\t\tvalue: function encode() {\n\t\t\tvar structure = _constants.EAN5_STRUCTURE[checksum(this.data)];\n\t\t\treturn {\n\t\t\t\tdata: '1011' + (0, _encoder2.default)(this.data, structure, '01'),\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\t}]);\n\n\treturn EAN5;\n}(_Barcode3.default);\n\nexports[\"default\"] = EAN5;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN5.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN8.js":
/*!*************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN8.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if (\"value\" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };\n\nvar _EAN2 = __webpack_require__(/*! ./EAN */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN.js\");\n\nvar _EAN3 = _interopRequireDefault(_EAN2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Encoding documentation:\n// http://www.barcodeisland.com/ean8.phtml\n\n// Calculate the checksum digit\nvar checksum = function checksum(number) {\n\tvar res = number.substr(0, 7).split('').map(function (n) {\n\t\treturn +n;\n\t}).reduce(function (sum, a, idx) {\n\t\treturn idx % 2 ? sum + a : sum + a * 3;\n\t}, 0);\n\n\treturn (10 - res % 10) % 10;\n};\n\nvar EAN8 = function (_EAN) {\n\t_inherits(EAN8, _EAN);\n\n\tfunction EAN8(data, options) {\n\t\t_classCallCheck(this, EAN8);\n\n\t\t// Add checksum if it does not exist\n\t\tif (data.search(/^[0-9]{7}$/) !== -1) {\n\t\t\tdata += checksum(data);\n\t\t}\n\n\t\treturn _possibleConstructorReturn(this, (EAN8.__proto__ || Object.getPrototypeOf(EAN8)).call(this, data, options));\n\t}\n\n\t_createClass(EAN8, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^[0-9]{8}$/) !== -1 && +this.data[7] === checksum(this.data);\n\t\t}\n\t}, {\n\t\tkey: 'leftText',\n\t\tvalue: function leftText() {\n\t\t\treturn _get(EAN8.prototype.__proto__ || Object.getPrototypeOf(EAN8.prototype), 'leftText', this).call(this, 0, 4);\n\t\t}\n\t}, {\n\t\tkey: 'leftEncode',\n\t\tvalue: function leftEncode() {\n\t\t\tvar data = this.data.substr(0, 4);\n\t\t\treturn _get(EAN8.prototype.__proto__ || Object.getPrototypeOf(EAN8.prototype), 'leftEncode', this).call(this, data, 'LLLL');\n\t\t}\n\t}, {\n\t\tkey: 'rightText',\n\t\tvalue: function rightText() {\n\t\t\treturn _get(EAN8.prototype.__proto__ || Object.getPrototypeOf(EAN8.prototype), 'rightText', this).call(this, 4, 4);\n\t\t}\n\t}, {\n\t\tkey: 'rightEncode',\n\t\tvalue: function rightEncode() {\n\t\t\tvar data = this.data.substr(4, 4);\n\t\t\treturn _get(EAN8.prototype.__proto__ || Object.getPrototypeOf(EAN8.prototype), 'rightEncode', this).call(this, data, 'RRRR');\n\t\t}\n\t}]);\n\n\treturn EAN8;\n}(_EAN3.default);\n\nexports[\"default\"] = EAN8;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN8.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPC.js":
/*!************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPC.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nexports.checksum = checksum;\n\nvar _encoder = __webpack_require__(/*! ./encoder */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js\");\n\nvar _encoder2 = _interopRequireDefault(_encoder);\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode.js */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Encoding documentation:\n// https://en.wikipedia.org/wiki/Universal_Product_Code#Encoding\n\nvar UPC = function (_Barcode) {\n\t_inherits(UPC, _Barcode);\n\n\tfunction UPC(data, options) {\n\t\t_classCallCheck(this, UPC);\n\n\t\t// Add checksum if it does not exist\n\t\tif (data.search(/^[0-9]{11}$/) !== -1) {\n\t\t\tdata += checksum(data);\n\t\t}\n\n\t\tvar _this = _possibleConstructorReturn(this, (UPC.__proto__ || Object.getPrototypeOf(UPC)).call(this, data, options));\n\n\t\t_this.displayValue = options.displayValue;\n\n\t\t// Make sure the font is not bigger than the space between the guard bars\n\t\tif (options.fontSize > options.width * 10) {\n\t\t\t_this.fontSize = options.width * 10;\n\t\t} else {\n\t\t\t_this.fontSize = options.fontSize;\n\t\t}\n\n\t\t// Make the guard bars go down half the way of the text\n\t\t_this.guardHeight = options.height + _this.fontSize / 2 + options.textMargin;\n\t\treturn _this;\n\t}\n\n\t_createClass(UPC, [{\n\t\tkey: \"valid\",\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^[0-9]{12}$/) !== -1 && this.data[11] == checksum(this.data);\n\t\t}\n\t}, {\n\t\tkey: \"encode\",\n\t\tvalue: function encode() {\n\t\t\tif (this.options.flat) {\n\t\t\t\treturn this.flatEncoding();\n\t\t\t} else {\n\t\t\t\treturn this.guardedEncoding();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: \"flatEncoding\",\n\t\tvalue: function flatEncoding() {\n\t\t\tvar result = \"\";\n\n\t\t\tresult += \"101\";\n\t\t\tresult += (0, _encoder2.default)(this.data.substr(0, 6), \"LLLLLL\");\n\t\t\tresult += \"01010\";\n\t\t\tresult += (0, _encoder2.default)(this.data.substr(6, 6), \"RRRRRR\");\n\t\t\tresult += \"101\";\n\n\t\t\treturn {\n\t\t\t\tdata: result,\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\t}, {\n\t\tkey: \"guardedEncoding\",\n\t\tvalue: function guardedEncoding() {\n\t\t\tvar result = [];\n\n\t\t\t// Add the first digit\n\t\t\tif (this.displayValue) {\n\t\t\t\tresult.push({\n\t\t\t\t\tdata: \"00000000\",\n\t\t\t\t\ttext: this.text.substr(0, 1),\n\t\t\t\t\toptions: { textAlign: \"left\", fontSize: this.fontSize }\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add the guard bars\n\t\t\tresult.push({\n\t\t\t\tdata: \"101\" + (0, _encoder2.default)(this.data[0], \"L\"),\n\t\t\t\toptions: { height: this.guardHeight }\n\t\t\t});\n\n\t\t\t// Add the left side\n\t\t\tresult.push({\n\t\t\t\tdata: (0, _encoder2.default)(this.data.substr(1, 5), \"LLLLL\"),\n\t\t\t\ttext: this.text.substr(1, 5),\n\t\t\t\toptions: { fontSize: this.fontSize }\n\t\t\t});\n\n\t\t\t// Add the middle bits\n\t\t\tresult.push({\n\t\t\t\tdata: \"01010\",\n\t\t\t\toptions: { height: this.guardHeight }\n\t\t\t});\n\n\t\t\t// Add the right side\n\t\t\tresult.push({\n\t\t\t\tdata: (0, _encoder2.default)(this.data.substr(6, 5), \"RRRRR\"),\n\t\t\t\ttext: this.text.substr(6, 5),\n\t\t\t\toptions: { fontSize: this.fontSize }\n\t\t\t});\n\n\t\t\t// Add the end bits\n\t\t\tresult.push({\n\t\t\t\tdata: (0, _encoder2.default)(this.data[11], \"R\") + \"101\",\n\t\t\t\toptions: { height: this.guardHeight }\n\t\t\t});\n\n\t\t\t// Add the last digit\n\t\t\tif (this.displayValue) {\n\t\t\t\tresult.push({\n\t\t\t\t\tdata: \"00000000\",\n\t\t\t\t\ttext: this.text.substr(11, 1),\n\t\t\t\t\toptions: { textAlign: \"right\", fontSize: this.fontSize }\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn result;\n\t\t}\n\t}]);\n\n\treturn UPC;\n}(_Barcode3.default);\n\n// Calulate the checksum digit\n// https://en.wikipedia.org/wiki/International_Article_Number_(EAN)#Calculation_of_checksum_digit\n\n\nfunction checksum(number) {\n\tvar result = 0;\n\n\tvar i;\n\tfor (i = 1; i < 11; i += 2) {\n\t\tresult += parseInt(number[i]);\n\t}\n\tfor (i = 0; i < 11; i += 2) {\n\t\tresult += parseInt(number[i]) * 3;\n\t}\n\n\treturn (10 - result % 10) % 10;\n}\n\nexports[\"default\"] = UPC;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPC.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPCE.js":
/*!*************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPCE.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _encoder = __webpack_require__(/*! ./encoder */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js\");\n\nvar _encoder2 = _interopRequireDefault(_encoder);\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode.js */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nvar _UPC = __webpack_require__(/*! ./UPC.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPC.js\");\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Encoding documentation:\n// https://en.wikipedia.org/wiki/Universal_Product_Code#Encoding\n//\n// UPC-E documentation:\n// https://en.wikipedia.org/wiki/Universal_Product_Code#UPC-E\n\nvar EXPANSIONS = [\"XX00000XXX\", \"XX10000XXX\", \"XX20000XXX\", \"XXX00000XX\", \"XXXX00000X\", \"XXXXX00005\", \"XXXXX00006\", \"XXXXX00007\", \"XXXXX00008\", \"XXXXX00009\"];\n\nvar PARITIES = [[\"EEEOOO\", \"OOOEEE\"], [\"EEOEOO\", \"OOEOEE\"], [\"EEOOEO\", \"OOEEOE\"], [\"EEOOOE\", \"OOEEEO\"], [\"EOEEOO\", \"OEOOEE\"], [\"EOOEEO\", \"OEEOOE\"], [\"EOOOEE\", \"OEEEOO\"], [\"EOEOEO\", \"OEOEOE\"], [\"EOEOOE\", \"OEOEEO\"], [\"EOOEOE\", \"OEEOEO\"]];\n\nvar UPCE = function (_Barcode) {\n\t_inherits(UPCE, _Barcode);\n\n\tfunction UPCE(data, options) {\n\t\t_classCallCheck(this, UPCE);\n\n\t\tvar _this = _possibleConstructorReturn(this, (UPCE.__proto__ || Object.getPrototypeOf(UPCE)).call(this, data, options));\n\t\t// Code may be 6 or 8 digits;\n\t\t// A 7 digit code is ambiguous as to whether the extra digit\n\t\t// is a UPC-A check or number system digit.\n\n\n\t\t_this.isValid = false;\n\t\tif (data.search(/^[0-9]{6}$/) !== -1) {\n\t\t\t_this.middleDigits = data;\n\t\t\t_this.upcA = expandToUPCA(data, \"0\");\n\t\t\t_this.text = options.text || '' + _this.upcA[0] + data + _this.upcA[_this.upcA.length - 1];\n\t\t\t_this.isValid = true;\n\t\t} else if (data.search(/^[01][0-9]{7}$/) !== -1) {\n\t\t\t_this.middleDigits = data.substring(1, data.length - 1);\n\t\t\t_this.upcA = expandToUPCA(_this.middleDigits, data[0]);\n\n\t\t\tif (_this.upcA[_this.upcA.length - 1] === data[data.length - 1]) {\n\t\t\t\t_this.isValid = true;\n\t\t\t} else {\n\t\t\t\t// checksum mismatch\n\t\t\t\treturn _possibleConstructorReturn(_this);\n\t\t\t}\n\t\t} else {\n\t\t\treturn _possibleConstructorReturn(_this);\n\t\t}\n\n\t\t_this.displayValue = options.displayValue;\n\n\t\t// Make sure the font is not bigger than the space between the guard bars\n\t\tif (options.fontSize > options.width * 10) {\n\t\t\t_this.fontSize = options.width * 10;\n\t\t} else {\n\t\t\t_this.fontSize = options.fontSize;\n\t\t}\n\n\t\t// Make the guard bars go down half the way of the text\n\t\t_this.guardHeight = options.height + _this.fontSize / 2 + options.textMargin;\n\t\treturn _this;\n\t}\n\n\t_createClass(UPCE, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.isValid;\n\t\t}\n\t}, {\n\t\tkey: 'encode',\n\t\tvalue: function encode() {\n\t\t\tif (this.options.flat) {\n\t\t\t\treturn this.flatEncoding();\n\t\t\t} else {\n\t\t\t\treturn this.guardedEncoding();\n\t\t\t}\n\t\t}\n\t}, {\n\t\tkey: 'flatEncoding',\n\t\tvalue: function flatEncoding() {\n\t\t\tvar result = \"\";\n\n\t\t\tresult += \"101\";\n\t\t\tresult += this.encodeMiddleDigits();\n\t\t\tresult += \"010101\";\n\n\t\t\treturn {\n\t\t\t\tdata: result,\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\t}, {\n\t\tkey: 'guardedEncoding',\n\t\tvalue: function guardedEncoding() {\n\t\t\tvar result = [];\n\n\t\t\t// Add the UPC-A number system digit beneath the quiet zone\n\t\t\tif (this.displayValue) {\n\t\t\t\tresult.push({\n\t\t\t\t\tdata: \"00000000\",\n\t\t\t\t\ttext: this.text[0],\n\t\t\t\t\toptions: { textAlign: \"left\", fontSize: this.fontSize }\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Add the guard bars\n\t\t\tresult.push({\n\t\t\t\tdata: \"101\",\n\t\t\t\toptions: { height: this.guardHeight }\n\t\t\t});\n\n\t\t\t// Add the 6 UPC-E digits\n\t\t\tresult.push({\n\t\t\t\tdata: this.encodeMiddleDigits(),\n\t\t\t\ttext: this.text.substring(1, 7),\n\t\t\t\toptions: { fontSize: this.fontSize }\n\t\t\t});\n\n\t\t\t// Add the end bits\n\t\t\tresult.push({\n\t\t\t\tdata: \"010101\",\n\t\t\t\toptions: { height: this.guardHeight }\n\t\t\t});\n\n\t\t\t// Add the UPC-A check digit beneath the quiet zone\n\t\t\tif (this.displayValue) {\n\t\t\t\tresult.push({\n\t\t\t\t\tdata: \"00000000\",\n\t\t\t\t\ttext: this.text[7],\n\t\t\t\t\toptions: { textAlign: \"right\", fontSize: this.fontSize }\n\t\t\t\t});\n\t\t\t}\n\n\t\t\treturn result;\n\t\t}\n\t}, {\n\t\tkey: 'encodeMiddleDigits',\n\t\tvalue: function encodeMiddleDigits() {\n\t\t\tvar numberSystem = this.upcA[0];\n\t\t\tvar checkDigit = this.upcA[this.upcA.length - 1];\n\t\t\tvar parity = PARITIES[parseInt(checkDigit)][parseInt(numberSystem)];\n\t\t\treturn (0, _encoder2.default)(this.middleDigits, parity);\n\t\t}\n\t}]);\n\n\treturn UPCE;\n}(_Barcode3.default);\n\nfunction expandToUPCA(middleDigits, numberSystem) {\n\tvar lastUpcE = parseInt(middleDigits[middleDigits.length - 1]);\n\tvar expansion = EXPANSIONS[lastUpcE];\n\n\tvar result = \"\";\n\tvar digitIndex = 0;\n\tfor (var i = 0; i < expansion.length; i++) {\n\t\tvar c = expansion[i];\n\t\tif (c === 'X') {\n\t\t\tresult += middleDigits[digitIndex++];\n\t\t} else {\n\t\t\tresult += c;\n\t\t}\n\t}\n\n\tresult = '' + numberSystem + result;\n\treturn '' + result + (0, _UPC.checksum)(result);\n}\n\nexports[\"default\"] = UPCE;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPCE.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js":
/*!******************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n// Standard start end and middle bits\nvar SIDE_BIN = exports.SIDE_BIN = '101';\nvar MIDDLE_BIN = exports.MIDDLE_BIN = '01010';\n\nvar BINARIES = exports.BINARIES = {\n\t'L': [// The L (left) type of encoding\n\t'0001101', '0011001', '0010011', '0111101', '0100011', '0110001', '0101111', '0111011', '0110111', '0001011'],\n\t'G': [// The G type of encoding\n\t'0100111', '0110011', '0011011', '0100001', '0011101', '0111001', '0000101', '0010001', '0001001', '0010111'],\n\t'R': [// The R (right) type of encoding\n\t'1110010', '1100110', '1101100', '1000010', '1011100', '1001110', '1010000', '1000100', '1001000', '1110100'],\n\t'O': [// The O (odd) encoding for UPC-E\n\t'0001101', '0011001', '0010011', '0111101', '0100011', '0110001', '0101111', '0111011', '0110111', '0001011'],\n\t'E': [// The E (even) encoding for UPC-E\n\t'0100111', '0110011', '0011011', '0100001', '0011101', '0111001', '0000101', '0010001', '0001001', '0010111']\n};\n\n// Define the EAN-2 structure\nvar EAN2_STRUCTURE = exports.EAN2_STRUCTURE = ['LL', 'LG', 'GL', 'GG'];\n\n// Define the EAN-5 structure\nvar EAN5_STRUCTURE = exports.EAN5_STRUCTURE = ['GGLLL', 'GLGLL', 'GLLGL', 'GLLLG', 'LGGLL', 'LLGGL', 'LLLGG', 'LGLGL', 'LGLLG', 'LLGLG'];\n\n// Define the EAN-13 structure\nvar EAN13_STRUCTURE = exports.EAN13_STRUCTURE = ['LLLLLL', 'LLGLGG', 'LLGGLG', 'LLGGGL', 'LGLLGG', 'LGGLLG', 'LGGGLL', 'LGLGLG', 'LGLGGL', 'LGGLGL'];\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js":
/*!****************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _constants = __webpack_require__(/*! ./constants */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/constants.js\");\n\n// Encode data string\nvar encode = function encode(data, structure, separator) {\n\tvar encoded = data.split('').map(function (val, idx) {\n\t\treturn _constants.BINARIES[structure[idx]];\n\t}).map(function (val, idx) {\n\t\treturn val ? val[data[idx]] : '';\n\t});\n\n\tif (separator) {\n\t\tvar last = data.length - 1;\n\t\tencoded = encoded.map(function (val, idx) {\n\t\t\treturn idx < last ? val + separator : val;\n\t\t});\n\t}\n\n\treturn encoded.join('');\n};\n\nexports[\"default\"] = encode;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/encoder.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/EAN_UPC/index.js":
/*!**************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/EAN_UPC/index.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.UPCE = exports.UPC = exports.EAN2 = exports.EAN5 = exports.EAN8 = exports.EAN13 = undefined;\n\nvar _EAN = __webpack_require__(/*! ./EAN13.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN13.js\");\n\nvar _EAN2 = _interopRequireDefault(_EAN);\n\nvar _EAN3 = __webpack_require__(/*! ./EAN8.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN8.js\");\n\nvar _EAN4 = _interopRequireDefault(_EAN3);\n\nvar _EAN5 = __webpack_require__(/*! ./EAN5.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN5.js\");\n\nvar _EAN6 = _interopRequireDefault(_EAN5);\n\nvar _EAN7 = __webpack_require__(/*! ./EAN2.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/EAN2.js\");\n\nvar _EAN8 = _interopRequireDefault(_EAN7);\n\nvar _UPC = __webpack_require__(/*! ./UPC.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPC.js\");\n\nvar _UPC2 = _interopRequireDefault(_UPC);\n\nvar _UPCE = __webpack_require__(/*! ./UPCE.js */ \"./node_modules/jsbarcode/bin/barcodes/EAN_UPC/UPCE.js\");\n\nvar _UPCE2 = _interopRequireDefault(_UPCE);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nexports.EAN13 = _EAN2.default;\nexports.EAN8 = _EAN4.default;\nexports.EAN5 = _EAN6.default;\nexports.EAN2 = _EAN8.default;\nexports.UPC = _UPC2.default;\nexports.UPCE = _UPCE2.default;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/EAN_UPC/index.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/GenericBarcode/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/GenericBarcode/index.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\nexports.GenericBarcode = undefined;\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode.js */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar GenericBarcode = function (_Barcode) {\n\t_inherits(GenericBarcode, _Barcode);\n\n\tfunction GenericBarcode(data, options) {\n\t\t_classCallCheck(this, GenericBarcode);\n\n\t\treturn _possibleConstructorReturn(this, (GenericBarcode.__proto__ || Object.getPrototypeOf(GenericBarcode)).call(this, data, options)); // Sets this.data and this.text\n\t}\n\n\t// Return the corresponding binary numbers for the data provided\n\n\n\t_createClass(GenericBarcode, [{\n\t\tkey: \"encode\",\n\t\tvalue: function encode() {\n\t\t\treturn {\n\t\t\t\tdata: \"10101010101010101010101010101010101010101\",\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\n\t\t// Resturn true/false if the string provided is valid for this encoder\n\n\t}, {\n\t\tkey: \"valid\",\n\t\tvalue: function valid() {\n\t\t\treturn true;\n\t\t}\n\t}]);\n\n\treturn GenericBarcode;\n}(_Barcode3.default);\n\nexports.GenericBarcode = GenericBarcode;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/GenericBarcode/index.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/ITF/ITF.js":
/*!********************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/ITF/ITF.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _constants = __webpack_require__(/*! ./constants */ \"./node_modules/jsbarcode/bin/barcodes/ITF/constants.js\");\n\nvar _Barcode2 = __webpack_require__(/*! ../Barcode */ \"./node_modules/jsbarcode/bin/barcodes/Barcode.js\");\n\nvar _Barcode3 = _interopRequireDefault(_Barcode2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\nvar ITF = function (_Barcode) {\n\t_inherits(ITF, _Barcode);\n\n\tfunction ITF() {\n\t\t_classCallCheck(this, ITF);\n\n\t\treturn _possibleConstructorReturn(this, (ITF.__proto__ || Object.getPrototypeOf(ITF)).apply(this, arguments));\n\t}\n\n\t_createClass(ITF, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^([0-9]{2})+$/) !== -1;\n\t\t}\n\t}, {\n\t\tkey: 'encode',\n\t\tvalue: function encode() {\n\t\t\tvar _this2 = this;\n\n\t\t\t// Calculate all the digit pairs\n\t\t\tvar encoded = this.data.match(/.{2}/g).map(function (pair) {\n\t\t\t\treturn _this2.encodePair(pair);\n\t\t\t}).join('');\n\n\t\t\treturn {\n\t\t\t\tdata: _constants.START_BIN + encoded + _constants.END_BIN,\n\t\t\t\ttext: this.text\n\t\t\t};\n\t\t}\n\n\t\t// Calculate the data of a number pair\n\n\t}, {\n\t\tkey: 'encodePair',\n\t\tvalue: function encodePair(pair) {\n\t\t\tvar second = _constants.BINARIES[pair[1]];\n\n\t\t\treturn _constants.BINARIES[pair[0]].split('').map(function (first, idx) {\n\t\t\t\treturn (first === '1' ? '111' : '1') + (second[idx] === '1' ? '000' : '0');\n\t\t\t}).join('');\n\t\t}\n\t}]);\n\n\treturn ITF;\n}(_Barcode3.default);\n\nexports[\"default\"] = ITF;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/ITF/ITF.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/ITF/ITF14.js":
/*!**********************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/ITF/ITF14.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\n\nvar _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();\n\nvar _ITF2 = __webpack_require__(/*! ./ITF */ \"./node_modules/jsbarcode/bin/barcodes/ITF/ITF.js\");\n\nvar _ITF3 = _interopRequireDefault(_ITF2);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\n// Calculate the checksum digit\nvar checksum = function checksum(data) {\n\tvar res = data.substr(0, 13).split('').map(function (num) {\n\t\treturn parseInt(num, 10);\n\t}).reduce(function (sum, n, idx) {\n\t\treturn sum + n * (3 - idx % 2 * 2);\n\t}, 0);\n\n\treturn Math.ceil(res / 10) * 10 - res;\n};\n\nvar ITF14 = function (_ITF) {\n\t_inherits(ITF14, _ITF);\n\n\tfunction ITF14(data, options) {\n\t\t_classCallCheck(this, ITF14);\n\n\t\t// Add checksum if it does not exist\n\t\tif (data.search(/^[0-9]{13}$/) !== -1) {\n\t\t\tdata += checksum(data);\n\t\t}\n\t\treturn _possibleConstructorReturn(this, (ITF14.__proto__ || Object.getPrototypeOf(ITF14)).call(this, data, options));\n\t}\n\n\t_createClass(ITF14, [{\n\t\tkey: 'valid',\n\t\tvalue: function valid() {\n\t\t\treturn this.data.search(/^[0-9]{14}$/) !== -1 && +this.data[13] === checksum(this.data);\n\t\t}\n\t}]);\n\n\treturn ITF14;\n}(_ITF3.default);\n\nexports[\"default\"] = ITF14;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/ITF/ITF14.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/ITF/constants.js":
/*!**************************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/ITF/constants.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n\tvalue: true\n}));\nvar START_BIN = exports.START_BIN = '1010';\nvar END_BIN = exports.END_BIN = '11101';\n\nvar BINARIES = exports.BINARIES = ['00110', '10001', '01001', '11000', '00101', '10100', '01100', '00011', '10010', '01010'];\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/ITF/constants.js?");

/***/ }),

/***/ "./node_modules/jsbarcode/bin/barcodes/ITF/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/jsbarcode/bin/barcodes/ITF/index.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

eval("\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.ITF14 = exports.ITF = undefined;\n\nvar _ITF = __webpack_require__(/*! ./ITF */ \"./node_modules/jsbarcode/bin/barcodes/ITF/ITF.js\");\n\nvar _ITF2 = _interopRequireDefault(_ITF);\n\nvar _ITF3 = __webpack_require__(/*! ./ITF14 */ \"./node_modules/jsbarcode/bin/barcodes/ITF/ITF14.js\");\n\nvar _ITF4 = _interopRequireDefault(_ITF3);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nexports.ITF = _ITF2.default;\nexports.ITF14 = _ITF4.default;\n\n//# sourceURL=webpack://myfrees_store/./node_modules/jsbarcode/bin/barcodes/ITF/index.js?");

/***/ })

}]);